#region usings
using System;
using System.ComponentModel.Composition;
using System.Linq;

using VVVV.PluginInterfaces.V1;
using VVVV.PluginInterfaces.V2;
using VVVV.Utils.VColor;
using VVVV.Utils.VMath;

using VVVV.Core.Logging;
#endregion usings

namespace VVVV.Nodes
{
	public enum ZalgoModes
	{
		MiniZalgo,
		NormalZalgo,
		MaxiZalgo
	}
	
	#region PluginInfo
	[PluginInfo(Name = "Zalgo", Category = "String", Help = "Scrambles input by abusing unicode", Author = "bjo:rn")]
	#endregion PluginInfo
	public class StringZalgoNode : IPluginEvaluate
	{
		#region fields & pins
		[Input("Input", DefaultString = "everything you know is wrong")]
		IDiffSpread<string> FInput;
		
		[Input("Zalgo Up", DefaultValue = 1 )]
		IDiffSpread<Boolean> FZalgoUp;
		
		[Input("Zalgo Middle", DefaultValue = 1 )]
		IDiffSpread<Boolean> FZalgoMiddle;
		
		[Input("Zalgo Down", DefaultValue = 1 )]
		IDiffSpread<Boolean> FZalgoDown;
		
		[Input("Zalgo Mode", DefaultEnumEntry = "MiniZalgo")]
		IDiffSpread<ZalgoModes> FZalgoMode;
		
		[Output("Output")]
		ISpread<string> FOutput;
		
		
		char[] zalgoUp = new char[] 
		{ 
			'\u030d', /*     Ì     */		'\u030e', /*     ÌŽ     */		'\u0304', /*     Ì„     */		'\u0305', /*     Ì…     */
			'\u033f', /*     Ì¿     */		'\u0311', /*     Ì‘     */		'\u0306', /*     Ì†     */		'\u0310', /*     Ì     */
			'\u0352', /*     Í’     */		'\u0357', /*     Í—     */		'\u0351', /*     Í‘     */		'\u0307', /*     Ì‡     */
			'\u0308', /*     Ìˆ     */		'\u030a', /*     ÌŠ     */		'\u0342', /*     Í‚     */		'\u0343', /*     Ì“     */
			'\u0344', /*     ÌˆÌ     */		'\u034a', /*     ÍŠ     */		'\u034b', /*     Í‹     */		'\u034c', /*     ÍŒ     */
			'\u0303', /*     Ìƒ     */		'\u0302', /*     Ì‚     */		'\u030c', /*     ÌŒ     */		'\u0350', /*     Í     */
			'\u0300', /*     Ì€     */		'\u0301', /*     Ì     */		'\u030b', /*     Ì‹     */		'\u030f', /*     Ì     */
			'\u0312', /*     Ì’     */		'\u0313', /*     Ì“     */		'\u0314', /*     Ì”     */		'\u033d', /*     Ì½     */
			'\u0309', /*     Ì‰     */		'\u0363', /*     Í£     */		'\u0364', /*     Í¤     */		'\u0365', /*     Í¥     */
			'\u0366', /*     Í¦     */		'\u0367', /*     Í§     */		'\u0368', /*     Í¨     */		'\u0369', /*     Í©     */
			'\u036a', /*     Íª     */		'\u036b', /*     Í«     */		'\u036c', /*     Í¬     */		'\u036d', /*     Í­     */
			'\u036e', /*     Í®     */		'\u036f', /*     Í¯     */		'\u033e', /*     Ì¾     */		'\u035b', /*     Í›     */
			'\u0346', /*     Í†     */		'\u031a' /*     Ìš     */
			
		};
		
		char[] zalgoDown = new char[] 
		{ 
			'\u0316', /*     Ì–     */		'\u0317', /*     Ì—     */		'\u0318', /*     Ì˜     */		'\u0319', /*     Ì™     */
			'\u031c', /*     Ìœ     */		'\u031d', /*     Ì     */		'\u031e', /*     Ìž     */		'\u031f', /*     ÌŸ     */
			'\u0320', /*     Ì      */		'\u0324', /*     Ì¤     */		'\u0325', /*     Ì¥     */		'\u0326', /*     Ì¦     */
			'\u0329', /*     Ì©     */		'\u032a', /*     Ìª     */		'\u032b', /*     Ì«     */		'\u032c', /*     Ì¬     */
			'\u032d', /*     Ì­     */		'\u032e', /*     Ì®     */		'\u032f', /*     Ì¯     */		'\u0330', /*     Ì°     */
			'\u0331', /*     Ì±     */		'\u0332', /*     Ì²     */		'\u0333', /*     Ì³     */		'\u0339', /*     Ì¹     */
			'\u033a', /*     Ìº     */		'\u033b', /*     Ì»     */		'\u033c', /*     Ì¼     */		'\u0345', /*     Í…     */
			'\u0347', /*     Í‡     */		'\u0348', /*     Íˆ     */		'\u0349', /*     Í‰     */		'\u034d', /*     Í     */
			'\u034e', /*     ÍŽ     */		'\u0353', /*     Í“     */		'\u0354', /*     Í”     */		'\u0355', /*     Í•     */
			'\u0356', /*     Í–     */		'\u0359', /*     Í™     */		'\u035a', /*     Íš     */		'\u0323' /*     Ì£     */
		};
		
		char[] zalgoMiddle = new char[] 
		{ 
			'\u0315', /*     Ì•     */		'\u031b', /*     Ì›     */		'\u0340', /*     Ì€     */		'\u0341', /*     Ì     */
			'\u0358', /*     Í˜     */		'\u0321', /*     Ì¡     */		'\u0322', /*     Ì¢     */		'\u0327', /*     Ì§     */
			'\u0328', /*     Ì¨     */		'\u0334', /*     Ì´     */		'\u0335', /*     Ìµ     */		'\u0336', /*     Ì¶     */
			'\u034f', /*     Í     */		'\u035c', /*     Íœ     */		'\u035d', /*     Í     */		'\u035e', /*     Íž     */
			'\u035f', /*     ÍŸ     */		'\u0360', /*     Í      */		'\u0362', /*     Í¢     */		'\u0338', /*     Ì¸     */
			'\u0337', /*     Ì·     */		'\u0361', /*     Í¡     */		'\u0489' /*     Ò‰_     */
		};
		
		
		
		[Import()]
		ILogger FLogger;
		#endregion fields & pins
		
		public bool isZango (char c)
		{
			if (zalgoUp.Contains(c)|| zalgoDown.Contains(c) || zalgoMiddle.Contains(c))
				return true;
			else
				return false;
		}
		

		//called when data for any output pin is requested
		public void Evaluate(int SpreadMax)
		{
			

			if (FInput.IsChanged || FZalgoMode.IsChanged || FZalgoUp.IsChanged || FZalgoDown.IsChanged || FZalgoMiddle.IsChanged  )
			{
				FOutput.SliceCount = SpreadMax;
				Random rnd = new Random();
				
				for (int i = 0; i < SpreadMax; i++)
				{
				
					string oldText = FInput[i];
					string newText = "";
					ZalgoModes zalgoMode =FZalgoMode[i];
					bool up = FZalgoUp[i];
					bool down = FZalgoDown[i];
					bool middle = FZalgoMiddle[i];
					
					
					
					for(int j = 0; j < oldText.Length; j++)
					{
						if(isZango(oldText[j])) continue;
						
						int num_up = 0;
						int num_mid = 0;
						int num_down = 0;
						
						newText += oldText[j];
						
						switch(zalgoMode)
						{
							case ZalgoModes.MiniZalgo:
							{
								num_up = rnd.Next(8);
								num_mid = rnd.Next(2);
								num_down = rnd.Next(8);
							}
							break;
							case ZalgoModes.NormalZalgo:
							{
								num_up = rnd.Next(16) / 2 + 1;
								num_mid = rnd.Next(6) / 2;
								num_down = rnd.Next(16) / 2 + 1;
							}
							break;
							case ZalgoModes.MaxiZalgo:
							{
								num_up = rnd.Next(64) / 4 + 3;
								num_mid = rnd.Next(16) / 4 + 1;
								num_down = rnd.Next(64) / 4 + 3;
							}
							break;
						}
						
						if (up)
						{
							for (int k = 0; k < num_up; k++)
							{
								newText += zalgoUp[rnd.Next(zalgoUp.Length)];
							}
						}
						
						if (down)
						{
							for (int k = 0; k < num_down; k++)
							{
								newText += zalgoDown[rnd.Next(zalgoDown.Length)];
							}
						}
						
						
						if (middle)
						{
							for (int k = 0; k < num_mid; k++)
							{
								newText += zalgoMiddle[rnd.Next(zalgoMiddle.Length)];
							}
						}
						
					}
					
					FOutput[i] = newText;
			
					
				}
			}
			
			

			//FLogger.Log(LogType.Debug, "Logging to Renderer (TTY)");
		}
	}
}
